/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat.calc;

import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apfloat.calc.AbstractCalculatorImpl;
import org.apfloat.calc.ParseException;

public abstract class FunctionCalculatorImpl
extends AbstractCalculatorImpl {
    private static final long serialVersionUID = 1L;
    private Map<String, Function> functions = new HashMap<String, Function>();

    protected FunctionCalculatorImpl() {
        this.setFunction("negate", this.fixedFunction("negate", 1, (functions, arguments) -> functions.negate((Number)arguments.get(0))));
        this.setFunction("add", this.fixedFunction("add", 2, (functions, arguments) -> functions.add((Number)arguments.get(0), (Number)arguments.get(1))));
        this.setFunction("subtract", this.fixedFunction("subtract", 2, (functions, arguments) -> functions.subtract((Number)arguments.get(0), (Number)arguments.get(1))));
        this.setFunction("multiply", this.fixedFunction("multiply", 2, (functions, arguments) -> functions.multiply((Number)arguments.get(0), (Number)arguments.get(1))));
        this.setFunction("divide", this.fixedFunction("divide", 2, (functions, arguments) -> functions.divide((Number)arguments.get(0), (Number)arguments.get(1))));
        this.setFunction("mod", this.fixedFunction("mod", 2, (functions, arguments) -> functions.mod((Number)arguments.get(0), (Number)arguments.get(1))));
        this.setFunction("pow", this.fixedFunction("pow", 2, (functions, arguments) -> functions.pow((Number)arguments.get(0), (Number)arguments.get(1))));
        this.setFunction("abs", this.fixedFunction("abs", 1, (functions, arguments) -> functions.abs((Number)arguments.get(0))));
        this.setFunction("acos", this.fixedFunction("acos", 1, (functions, arguments) -> functions.acos((Number)arguments.get(0))));
        this.setFunction("acosh", this.fixedFunction("acosh", 1, (functions, arguments) -> functions.acosh((Number)arguments.get(0))));
        this.setFunction("airyAi", this.fixedFunction("airyAi", 1, (functions, arguments) -> functions.airyAi((Number)arguments.get(0))));
        this.setFunction("airyAiPrime", this.fixedFunction("airyAiPrime", 1, (functions, arguments) -> functions.airyAiPrime((Number)arguments.get(0))));
        this.setFunction("airyBi", this.fixedFunction("airyBi", 1, (functions, arguments) -> functions.airyBi((Number)arguments.get(0))));
        this.setFunction("airyBiPrime", this.fixedFunction("airyBiPrime", 1, (functions, arguments) -> functions.airyBiPrime((Number)arguments.get(0))));
        this.setFunction("angerJ", this.fixedFunction("angerJ", 2, (functions, arguments) -> functions.angerJ((Number)arguments.get(0), (Number)arguments.get(1))));
        this.setFunction("asin", this.fixedFunction("asin", 1, (functions, arguments) -> functions.asin((Number)arguments.get(0))));
        this.setFunction("asinh", this.fixedFunction("asinh", 1, (functions, arguments) -> functions.asinh((Number)arguments.get(0))));
        this.setFunction("atan", this.fixedFunction("atan", 1, (functions, arguments) -> functions.atan((Number)arguments.get(0))));
        this.setFunction("atanh", this.fixedFunction("atanh", 1, (functions, arguments) -> functions.atanh((Number)arguments.get(0))));
        this.setFunction("bernoulli", this.fixedFunction("bernoulli", 1, (functions, arguments) -> functions.bernoulli((Number)arguments.get(0))));
        this.setFunction("bernoulliB", this.fixedFunction("bernoulliB", 2, (functions, arguments) -> functions.bernoulliB((Number)arguments.get(0), (Number)arguments.get(1))));
        this.setFunction("besselI", this.fixedFunction("besselI", 2, (functions, arguments) -> functions.besselI((Number)arguments.get(0), (Number)arguments.get(1))));
        this.setFunction("besselJ", this.fixedFunction("besselJ", 2, (functions, arguments) -> functions.besselJ((Number)arguments.get(0), (Number)arguments.get(1))));
        this.setFunction("besselK", this.fixedFunction("besselK", 2, (functions, arguments) -> functions.besselK((Number)arguments.get(0), (Number)arguments.get(1))));
        this.setFunction("besselY", this.fixedFunction("besselY", 2, (functions, arguments) -> functions.besselY((Number)arguments.get(0), (Number)arguments.get(1))));
        this.setFunction("beta", this.fixedFunction("beta", 2, 4, (functions, arguments) -> arguments.size() == 2 ? (Number)functions.beta((Number)arguments.get(0), (Number)arguments.get(1)) : (Number)(arguments.size() == 3 ? (Number)functions.beta((Number)arguments.get(0), (Number)arguments.get(1), (Number)arguments.get(2)) : (Number)functions.beta((Number)arguments.get(0), (Number)arguments.get(1), (Number)arguments.get(2), (Number)arguments.get(3)))));
        this.setFunction("binomial", this.fixedFunction("binomial", 2, (functions, arguments) -> functions.binomial((Number)arguments.get(0), (Number)arguments.get(1))));
        this.setFunction("catalan", this.fixedFunction("catalan", 0, 1, (functions, arguments) -> functions.catalan(this.argumentOrInputPrecision(arguments))));
        this.setFunction("cbrt", this.fixedFunction("cbrt", 1, (functions, arguments) -> functions.cbrt((Number)arguments.get(0))));
        this.setFunction("ceil", this.fixedFunction("ceil", 1, (functions, arguments) -> functions.ceil((Number)arguments.get(0))));
        this.setFunction("chebyshevT", this.fixedFunction("chebyshevT", 2, (functions, arguments) -> functions.chebyshevT((Number)arguments.get(0), (Number)arguments.get(1))));
        this.setFunction("chebyshevU", this.fixedFunction("chebyshevU", 2, (functions, arguments) -> functions.chebyshevU((Number)arguments.get(0), (Number)arguments.get(1))));
        this.setFunction("cos", this.fixedFunction("cos", 1, (functions, arguments) -> functions.cos((Number)arguments.get(0))));
        this.setFunction("cosIntegral", this.fixedFunction("cosIntegral", 1, (functions, arguments) -> functions.cosIntegral((Number)arguments.get(0))));
        this.setFunction("cosh", this.fixedFunction("cosh", 1, (functions, arguments) -> functions.cosh((Number)arguments.get(0))));
        this.setFunction("coshIntegral", this.fixedFunction("coshIntegral", 1, (functions, arguments) -> functions.coshIntegral((Number)arguments.get(0))));
        this.setFunction("digamma", this.fixedFunction("digamma", 1, (functions, arguments) -> functions.digamma((Number)arguments.get(0))));
        this.setFunction("doubleFactorial", this.fixedFunction("doubleFactorial", 1, (functions, arguments) -> functions.doubleFactorial((Number)arguments.get(0))));
        this.setFunction("e", this.fixedFunction("e", 0, 1, (functions, arguments) -> functions.e(this.argumentOrInputPrecision(arguments))));
        this.setFunction("ellipticE", this.fixedFunction("ellipticE", 1, (functions, arguments) -> functions.ellipticE((Number)arguments.get(0))));
        this.setFunction("ellipticK", this.fixedFunction("ellipticK", 1, (functions, arguments) -> functions.ellipticK((Number)arguments.get(0))));
        this.setFunction("erf", this.fixedFunction("erf", 1, (functions, arguments) -> functions.erf((Number)arguments.get(0))));
        this.setFunction("erfc", this.fixedFunction("erfc", 1, (functions, arguments) -> functions.erfc((Number)arguments.get(0))));
        this.setFunction("erfi", this.fixedFunction("erfi", 1, (functions, arguments) -> functions.erfi((Number)arguments.get(0))));
        this.setFunction("euler", this.fixedFunction("euler", 0, 1, (functions, arguments) -> functions.euler(this.argumentOrInputPrecision(arguments))));
        this.setFunction("eulerE", this.fixedFunction("eulerE", 2, (functions, arguments) -> functions.eulerE((Number)arguments.get(0), (Number)arguments.get(1))));
        this.setFunction("exp", this.fixedFunction("exp", 1, (functions, arguments) -> functions.exp((Number)arguments.get(0))));
        this.setFunction("expIntegralE", this.fixedFunction("expIntegralE", 2, (functions, arguments) -> functions.expIntegralE((Number)arguments.get(0), (Number)arguments.get(1))));
        this.setFunction("expIntegralEi", this.fixedFunction("expIntegralEi", 1, (functions, arguments) -> functions.expIntegralEi((Number)arguments.get(0))));
        this.setFunction("factorial", this.fixedFunction("factorial", 1, (functions, arguments) -> functions.factorial((Number)arguments.get(0))));
        this.setFunction("fibonacci", this.fixedFunction("fibonacci", 2, (functions, arguments) -> functions.fibonacci((Number)arguments.get(0), (Number)arguments.get(1))));
        this.setFunction("floor", this.fixedFunction("floor", 1, (functions, arguments) -> functions.floor((Number)arguments.get(0))));
        this.setFunction("frac", this.fixedFunction("frac", 1, (functions, arguments) -> functions.frac((Number)arguments.get(0))));
        this.setFunction("fresnelC", this.fixedFunction("fresnelC", 1, (functions, arguments) -> functions.fresnelC((Number)arguments.get(0))));
        this.setFunction("fresnelS", this.fixedFunction("fresnelS", 1, (functions, arguments) -> functions.fresnelS((Number)arguments.get(0))));
        this.setFunction("gamma", this.fixedFunction("gamma", 1, 3, (functions, arguments) -> arguments.size() == 1 ? (Number)functions.gamma((Number)arguments.get(0)) : (Number)(arguments.size() == 2 ? (Number)functions.gamma((Number)arguments.get(0), (Number)arguments.get(1)) : (Number)functions.gamma((Number)arguments.get(0), (Number)arguments.get(1), (Number)arguments.get(2)))));
        this.setFunction("gegenbauerC", this.fixedFunction("gegenbauerC", 2, 3, (functions, arguments) -> arguments.size() == 2 ? (Number)functions.gegenbauerC((Number)arguments.get(0), (Number)arguments.get(1)) : (Number)functions.gegenbauerC((Number)arguments.get(0), (Number)arguments.get(1), (Number)arguments.get(2))));
        this.setFunction("glaisher", this.fixedFunction("glaisher", 0, 1, (functions, arguments) -> functions.glaisher(this.argumentOrInputPrecision(arguments))));
        this.setFunction("harmonicNumber", this.fixedFunction("harmonicNumber", 1, 2, (functions, arguments) -> arguments.size() == 1 ? (Number)functions.harmonicNumber((Number)arguments.get(0)) : (Number)functions.harmonicNumber((Number)arguments.get(0), (Number)arguments.get(1))));
        this.setFunction("hermiteH", this.fixedFunction("hermiteH", 2, (functions, arguments) -> functions.hermiteH((Number)arguments.get(0), (Number)arguments.get(1))));
        this.setFunction("hypergeometric0F1", this.fixedFunction("hypergeometric0F1", 2, (functions, arguments) -> functions.hypergeometric0F1((Number)arguments.get(0), (Number)arguments.get(1))));
        this.setFunction("hypergeometric0F1Regularized", this.fixedFunction("hypergeometric0F1Regularized", 2, (functions, arguments) -> functions.hypergeometric0F1Regularized((Number)arguments.get(0), (Number)arguments.get(1))));
        this.setFunction("hypergeometric1F1", this.fixedFunction("hypergeometric1F1", 3, (functions, arguments) -> functions.hypergeometric1F1((Number)arguments.get(0), (Number)arguments.get(1), (Number)arguments.get(2))));
        this.setFunction("hypergeometric1F1Regularized", this.fixedFunction("hypergeometric1F1Regularized", 3, (functions, arguments) -> functions.hypergeometric1F1Regularized((Number)arguments.get(0), (Number)arguments.get(1), (Number)arguments.get(2))));
        this.setFunction("hypergeometric2F1", this.fixedFunction("hypergeometric2F1", 4, (functions, arguments) -> functions.hypergeometric2F1((Number)arguments.get(0), (Number)arguments.get(1), (Number)arguments.get(2), (Number)arguments.get(3))));
        this.setFunction("hypergeometric2F1Regularized", this.fixedFunction("hypergeometric2F1Regularized", 4, (functions, arguments) -> functions.hypergeometric2F1Regularized((Number)arguments.get(0), (Number)arguments.get(1), (Number)arguments.get(2), (Number)arguments.get(3))));
        this.setFunction("hypergeometricU", this.fixedFunction("hypergeometricU", 3, (functions, arguments) -> functions.hypergeometricU((Number)arguments.get(0), (Number)arguments.get(1), (Number)arguments.get(2))));
        this.setFunction("inverseErf", this.fixedFunction("inverseErf", 1, (functions, arguments) -> functions.inverseErf((Number)arguments.get(0))));
        this.setFunction("inverseErfc", this.fixedFunction("inverseErfc", 1, (functions, arguments) -> functions.inverseErfc((Number)arguments.get(0))));
        this.setFunction("jacobiP", this.fixedFunction("jacobiP", 4, (functions, arguments) -> functions.jacobiP((Number)arguments.get(0), (Number)arguments.get(1), (Number)arguments.get(2), (Number)arguments.get(3))));
        this.setFunction("khinchin", this.fixedFunction("khinchin", 0, 1, (functions, arguments) -> functions.khinchin(this.argumentOrInputPrecision(arguments))));
        this.setFunction("laguerreL", this.fixedFunction("laguerreL", 2, 3, (functions, arguments) -> arguments.size() == 2 ? (Number)functions.laguerreL((Number)arguments.get(0), (Number)arguments.get(1)) : (Number)functions.laguerreL((Number)arguments.get(0), (Number)arguments.get(1), (Number)arguments.get(2))));
        this.setFunction("legendreP", this.fixedFunction("legendreP", 2, 3, (functions, arguments) -> arguments.size() == 2 ? (Number)functions.legendreP((Number)arguments.get(0), (Number)arguments.get(1)) : (Number)functions.legendreP((Number)arguments.get(0), (Number)arguments.get(1), (Number)arguments.get(2))));
        this.setFunction("legendreQ", this.fixedFunction("legendreQ", 2, 3, (functions, arguments) -> arguments.size() == 2 ? (Number)functions.legendreQ((Number)arguments.get(0), (Number)arguments.get(1)) : (Number)functions.legendreQ((Number)arguments.get(0), (Number)arguments.get(1), (Number)arguments.get(2))));
        this.setFunction("log", this.fixedFunction("log", 1, 2, (functions, arguments) -> arguments.size() == 1 ? (Number)functions.log((Number)arguments.get(0)) : (Number)functions.log((Number)arguments.get(0), (Number)arguments.get(1))));
        this.setFunction("logGamma", this.fixedFunction("logGamma", 1, (functions, arguments) -> functions.logGamma((Number)arguments.get(0))));
        this.setFunction("logIntegral", this.fixedFunction("logIntegral", 1, (functions, arguments) -> functions.logIntegral((Number)arguments.get(0))));
        this.setFunction("logisticSigmoid", this.fixedFunction("logisticSigmoid", 1, (functions, arguments) -> functions.logisticSigmoid((Number)arguments.get(0))));
        this.setFunction("max", this.fixedFunction("max", 2, (functions, arguments) -> functions.max((Number)arguments.get(0), (Number)arguments.get(1))));
        this.setFunction("min", this.fixedFunction("min", 2, (functions, arguments) -> functions.min((Number)arguments.get(0), (Number)arguments.get(1))));
        this.setFunction("nextAfter", this.fixedFunction("nextAfter", 2, (functions, arguments) -> functions.nextAfter((Number)arguments.get(0), (Number)arguments.get(1))));
        this.setFunction("nextDown", this.fixedFunction("nextDown", 1, (functions, arguments) -> functions.nextDown((Number)arguments.get(0))));
        this.setFunction("nextUp", this.fixedFunction("nextUp", 1, (functions, arguments) -> functions.nextUp((Number)arguments.get(0))));
        this.setFunction("pi", this.fixedFunction("pi", 0, 1, (functions, arguments) -> functions.pi(this.argumentOrInputPrecision(arguments))));
        this.setFunction("pochhammer", this.fixedFunction("pochhammer", 2, (functions, arguments) -> functions.pochhammer((Number)arguments.get(0), (Number)arguments.get(1))));
        this.setFunction("polygamma", this.fixedFunction("polygamma", 2, (functions, arguments) -> functions.polygamma((Number)arguments.get(0), (Number)arguments.get(1))));
        this.setFunction("polylog", this.fixedFunction("polylog", 2, (functions, arguments) -> functions.polylog((Number)arguments.get(0), (Number)arguments.get(1))));
        this.setFunction("random", this.fixedFunction("random", 0, 1, (functions, arguments) -> functions.random(this.argumentOrInputPrecision(arguments))));
        this.setFunction("randomGaussian", this.fixedFunction("randomGaussian", 0, 1, (functions, arguments) -> functions.randomGaussian(this.argumentOrInputPrecision(arguments))));
        this.setFunction("round", this.fixedFunction("round", 2, (functions, arguments) -> functions.round((Number)arguments.get(0), (Number)arguments.get(1))));
        this.setFunction("roundToPrecision", this.fixedFunction("roundToPrecision", 2, (functions, arguments) -> functions.roundToPrecision((Number)arguments.get(0), (Number)arguments.get(1))));
        this.setFunction("roundToInteger", this.fixedFunction("roundToInteger", 1, (functions, arguments) -> functions.roundToInteger((Number)arguments.get(0))));
        this.setFunction("roundToPlaces", this.fixedFunction("roundToPlaces", 2, (functions, arguments) -> functions.roundToPlaces((Number)arguments.get(0), (Number)arguments.get(1))));
        this.setFunction("roundToMultiple", this.fixedFunction("roundToMultiple", 2, (functions, arguments) -> functions.roundToMultiple((Number)arguments.get(0), (Number)arguments.get(1))));
        this.setFunction("sin", this.fixedFunction("sin", 1, (functions, arguments) -> functions.sin((Number)arguments.get(0))));
        this.setFunction("sinc", this.fixedFunction("sinc", 1, (functions, arguments) -> functions.sinc((Number)arguments.get(0))));
        this.setFunction("sinIntegral", this.fixedFunction("sinIntegral", 1, (functions, arguments) -> functions.sinIntegral((Number)arguments.get(0))));
        this.setFunction("sinh", this.fixedFunction("sinh", 1, (functions, arguments) -> functions.sinh((Number)arguments.get(0))));
        this.setFunction("sinhIntegral", this.fixedFunction("sinhIntegral", 1, (functions, arguments) -> functions.sinhIntegral((Number)arguments.get(0))));
        this.setFunction("sphericalHarmonicY", this.fixedFunction("sphericalHarmonicY", 4, (functions, arguments) -> functions.sphericalHarmonicY((Number)arguments.get(0), (Number)arguments.get(1), (Number)arguments.get(2), (Number)arguments.get(3))));
        this.setFunction("sqrt", this.fixedFunction("sqrt", 1, (functions, arguments) -> functions.sqrt((Number)arguments.get(0))));
        this.setFunction("struveH", this.fixedFunction("struveH", 2, (functions, arguments) -> functions.struveH((Number)arguments.get(0), (Number)arguments.get(1))));
        this.setFunction("struveL", this.fixedFunction("struveL", 2, (functions, arguments) -> functions.struveL((Number)arguments.get(0), (Number)arguments.get(1))));
        this.setFunction("tan", this.fixedFunction("tan", 1, (functions, arguments) -> functions.tan((Number)arguments.get(0))));
        this.setFunction("tanh", this.fixedFunction("tanh", 1, (functions, arguments) -> functions.tanh((Number)arguments.get(0))));
        this.setFunction("truncate", this.fixedFunction("truncate", 1, (functions, arguments) -> functions.truncate((Number)arguments.get(0))));
        this.setFunction("toDegrees", this.fixedFunction("toDegrees", 1, (functions, arguments) -> functions.toDegrees((Number)arguments.get(0))));
        this.setFunction("toRadians", this.fixedFunction("toRadians", 1, (functions, arguments) -> functions.toRadians((Number)arguments.get(0))));
        this.setFunction("ulp", this.fixedFunction("ulp", 1, (functions, arguments) -> functions.ulp((Number)arguments.get(0))));
        this.setFunction("weberE", this.fixedFunction("weberE", 2, (functions, arguments) -> functions.weberE((Number)arguments.get(0), (Number)arguments.get(1))));
        this.setFunction("zeta", this.fixedFunction("zeta", 1, 2, (functions, arguments) -> arguments.size() == 1 ? (Number)functions.zeta((Number)arguments.get(0)) : (Number)functions.zeta((Number)arguments.get(0), (Number)arguments.get(1))));
        this.setFunction("arg", this.fixedFunction("arg", 1, (functions, arguments) -> functions.arg((Number)arguments.get(0))));
        this.setFunction("conj", this.fixedFunction("conj", 1, (functions, arguments) -> functions.conj((Number)arguments.get(0))));
        this.setFunction("imag", this.fixedFunction("imag", 1, (functions, arguments) -> functions.imag((Number)arguments.get(0))));
        this.setFunction("real", this.fixedFunction("real", 1, (functions, arguments) -> functions.real((Number)arguments.get(0))));
        this.setFunction("agm", this.fixedFunction("agm", 2, (functions, arguments) -> functions.agm((Number)arguments.get(0), (Number)arguments.get(1))));
        this.setFunction("w", this.fixedFunction("w", 1, 2, (functions, arguments) -> arguments.size() == 1 ? (Number)functions.w((Number)arguments.get(0)) : (Number)functions.w((Number)arguments.get(0), (Number)arguments.get(1))));
        this.setFunction("atan2", this.fixedFunction("atan2", 2, (functions, arguments) -> functions.atan2((Number)arguments.get(0), (Number)arguments.get(1))));
        this.setFunction("copySign", this.fixedFunction("copySign", 2, (functions, arguments) -> functions.copySign((Number)arguments.get(0), (Number)arguments.get(1))));
        this.setFunction("fmod", this.fixedFunction("fmod", 2, (functions, arguments) -> functions.fmod((Number)arguments.get(0), (Number)arguments.get(1))));
        this.setFunction("gcd", this.fixedFunction("gcd", 2, (functions, arguments) -> functions.gcd((Number)arguments.get(0), (Number)arguments.get(1))));
        this.setFunction("hypot", this.fixedFunction("hypot", 2, (functions, arguments) -> functions.hypot((Number)arguments.get(0), (Number)arguments.get(1))));
        this.setFunction("inverseRoot", this.fixedFunction("inverseRoot", 2, 3, (functions, arguments) -> arguments.size() == 2 ? (Number)functions.inverseRoot((Number)arguments.get(0), (Number)arguments.get(1)) : (Number)functions.inverseRoot((Number)arguments.get(0), (Number)arguments.get(1), (Number)arguments.get(2))));
        this.setFunction("lcm", this.fixedFunction("lcm", 2, (functions, arguments) -> functions.lcm((Number)arguments.get(0), (Number)arguments.get(1))));
        this.setFunction("root", this.fixedFunction("root", 2, 3, (functions, arguments) -> arguments.size() == 2 ? (Number)functions.root((Number)arguments.get(0), (Number)arguments.get(1)) : (Number)functions.root((Number)arguments.get(0), (Number)arguments.get(1), (Number)arguments.get(2))));
        this.setFunction("scale", this.fixedFunction("scale", 2, (functions, arguments) -> functions.scale((Number)arguments.get(0), (Number)arguments.get(1))));
        this.setFunction("n", this.fixedFunction("precision", 2, (functions, arguments) -> functions.precision((Number)arguments.get(0), (Number)arguments.get(1))));
    }

    @Override
    public Number function(String name, List<Number> arguments) throws ParseException {
        Function function = this.functions.get(name);
        if (function == null) {
            throw new ParseException("Invalid function: " + name);
        }
        return function.call(arguments);
    }

    private Functions getFunctions(List<Number> arguments) {
        Functions functions = arguments.isEmpty() ? this.getFunctions((Number)null) : null;
        for (Number argument : arguments) {
            Functions functions2 = this.getFunctions(argument);
            functions = functions != null && functions.getClass().isAssignableFrom(functions2.getClass()) ? functions : functions2;
        }
        return functions;
    }

    private Number argumentOrInputPrecision(List<Number> arguments) {
        return arguments.size() == 0 ? (Number)this.getInputPrecision() : (Number)arguments.get(0);
    }

    protected FixedFunction fixedFunction(String name, int arguments, FixedFunctionHandler handler) {
        return this.fixedFunction(name, arguments, arguments, handler);
    }

    protected FixedFunction fixedFunction(String name, int minArguments, int maxArguments, FixedFunctionHandler handler) {
        FixedFunction fixedFunction = new FixedFunction();
        fixedFunction.name = name;
        fixedFunction.minArguments = minArguments;
        fixedFunction.maxArguments = maxArguments;
        fixedFunction.handler = handler;
        return fixedFunction;
    }

    protected void setFunction(String name, Function function) {
        this.functions.put(name, function);
    }

    protected abstract Functions getFunctions(Number var1);

    protected abstract Number promote(Number var1);

    protected static interface Functions {
        public Number negate(Number var1);

        public Number add(Number var1, Number var2);

        public Number subtract(Number var1, Number var2);

        public Number multiply(Number var1, Number var2);

        public Number divide(Number var1, Number var2);

        public Number mod(Number var1, Number var2);

        public Number pow(Number var1, Number var2);

        public Number arg(Number var1);

        public Number conj(Number var1);

        public Number imag(Number var1);

        public Number real(Number var1);

        public Number abs(Number var1);

        public Number acos(Number var1);

        public Number acosh(Number var1);

        public Number airyAi(Number var1);

        public Number airyAiPrime(Number var1);

        public Number airyBi(Number var1);

        public Number airyBiPrime(Number var1);

        public Number angerJ(Number var1, Number var2);

        public Number asin(Number var1);

        public Number asinh(Number var1);

        public Number atan(Number var1);

        public Number atanh(Number var1);

        public Number bernoulli(Number var1);

        public Number bernoulliB(Number var1, Number var2);

        public Number besselI(Number var1, Number var2);

        public Number besselJ(Number var1, Number var2);

        public Number besselK(Number var1, Number var2);

        public Number besselY(Number var1, Number var2);

        public Number beta(Number var1, Number var2);

        public Number beta(Number var1, Number var2, Number var3);

        public Number beta(Number var1, Number var2, Number var3, Number var4);

        public Number binomial(Number var1, Number var2);

        public Number catalan(Number var1);

        public Number cbrt(Number var1);

        public Number ceil(Number var1);

        public Number chebyshevT(Number var1, Number var2);

        public Number chebyshevU(Number var1, Number var2);

        public Number cos(Number var1);

        public Number cosIntegral(Number var1);

        public Number cosh(Number var1);

        public Number coshIntegral(Number var1);

        public Number digamma(Number var1);

        public Number doubleFactorial(Number var1);

        public Number e(Number var1);

        public Number ellipticE(Number var1);

        public Number ellipticK(Number var1);

        public Number erf(Number var1);

        public Number erfc(Number var1);

        public Number erfi(Number var1);

        public Number euler(Number var1);

        public Number eulerE(Number var1, Number var2);

        public Number exp(Number var1);

        public Number expIntegralE(Number var1, Number var2);

        public Number expIntegralEi(Number var1);

        public Number factorial(Number var1);

        public Number fibonacci(Number var1, Number var2);

        public Number floor(Number var1);

        public Number frac(Number var1);

        public Number fresnelC(Number var1);

        public Number fresnelS(Number var1);

        public Number gamma(Number var1);

        public Number gamma(Number var1, Number var2);

        public Number gamma(Number var1, Number var2, Number var3);

        public Number gegenbauerC(Number var1, Number var2);

        public Number gegenbauerC(Number var1, Number var2, Number var3);

        public Number harmonicNumber(Number var1);

        public Number harmonicNumber(Number var1, Number var2);

        public Number hermiteH(Number var1, Number var2);

        public Number hypergeometric0F1(Number var1, Number var2);

        public Number hypergeometric0F1Regularized(Number var1, Number var2);

        public Number hypergeometric1F1(Number var1, Number var2, Number var3);

        public Number hypergeometric1F1Regularized(Number var1, Number var2, Number var3);

        public Number hypergeometric2F1(Number var1, Number var2, Number var3, Number var4);

        public Number hypergeometric2F1Regularized(Number var1, Number var2, Number var3, Number var4);

        public Number hypergeometricU(Number var1, Number var2, Number var3);

        public Number inverseErf(Number var1);

        public Number inverseErfc(Number var1);

        public Number jacobiP(Number var1, Number var2, Number var3, Number var4);

        public Number glaisher(Number var1);

        public Number khinchin(Number var1);

        public Number laguerreL(Number var1, Number var2);

        public Number laguerreL(Number var1, Number var2, Number var3);

        public Number legendreP(Number var1, Number var2);

        public Number legendreP(Number var1, Number var2, Number var3);

        public Number legendreQ(Number var1, Number var2);

        public Number legendreQ(Number var1, Number var2, Number var3);

        public Number log(Number var1);

        public Number log(Number var1, Number var2);

        public Number logGamma(Number var1);

        public Number logIntegral(Number var1);

        public Number logisticSigmoid(Number var1);

        public Number max(Number var1, Number var2);

        public Number min(Number var1, Number var2);

        public Number nextAfter(Number var1, Number var2);

        public Number nextDown(Number var1);

        public Number nextUp(Number var1);

        public Number pi(Number var1);

        public Number pochhammer(Number var1, Number var2);

        public Number polygamma(Number var1, Number var2);

        public Number polylog(Number var1, Number var2);

        public Number random(Number var1);

        public Number randomGaussian(Number var1);

        @Deprecated
        public Number round(Number var1, Number var2);

        public Number roundToPrecision(Number var1, Number var2);

        public Number roundToInteger(Number var1);

        public Number roundToPlaces(Number var1, Number var2);

        public Number roundToMultiple(Number var1, Number var2);

        public Number sin(Number var1);

        public Number sinc(Number var1);

        public Number sinIntegral(Number var1);

        public Number sinh(Number var1);

        public Number sinhIntegral(Number var1);

        public Number sphericalHarmonicY(Number var1, Number var2, Number var3, Number var4);

        public Number sqrt(Number var1);

        public Number struveH(Number var1, Number var2);

        public Number struveL(Number var1, Number var2);

        public Number tan(Number var1);

        public Number tanh(Number var1);

        public Number truncate(Number var1);

        public Number toDegrees(Number var1);

        public Number toRadians(Number var1);

        public Number ulp(Number var1);

        public Number weberE(Number var1, Number var2);

        public Number zeta(Number var1);

        public Number zeta(Number var1, Number var2);

        public Number agm(Number var1, Number var2);

        public Number w(Number var1);

        public Number w(Number var1, Number var2);

        public Number atan2(Number var1, Number var2);

        public Number copySign(Number var1, Number var2);

        public Number fmod(Number var1, Number var2);

        public Number gcd(Number var1, Number var2);

        public Number hypot(Number var1, Number var2);

        public Number inverseRoot(Number var1, Number var2);

        public Number inverseRoot(Number var1, Number var2, Number var3);

        public Number lcm(Number var1, Number var2);

        public Number root(Number var1, Number var2);

        public Number root(Number var1, Number var2, Number var3);

        public Number scale(Number var1, Number var2);

        public Number precision(Number var1, Number var2);
    }

    @FunctionalInterface
    protected static interface FixedFunctionHandler
    extends Serializable {
        public Number call(Functions var1, List<Number> var2);
    }

    protected class FixedFunction
    implements Function {
        private static final long serialVersionUID = 1L;
        private String name;
        private int minArguments;
        private int maxArguments;
        private FixedFunctionHandler handler;

        protected FixedFunction() {
        }

        protected void validate(List<Number> arguments) throws ParseException {
            if (this.minArguments == this.maxArguments && arguments.size() != this.minArguments) {
                throw new ParseException("Function " + this.name + " takes " + this.minArguments + " argument" + (this.minArguments == 1 ? "" : "s") + ", not " + arguments.size());
            }
            if (arguments.size() < this.minArguments || arguments.size() > this.maxArguments) {
                throw new ParseException("Function " + this.name + " takes " + this.minArguments + " to " + this.maxArguments + " arguments, not " + arguments.size());
            }
        }

        @Override
        public final Number call(List<Number> arguments) throws ParseException {
            this.validate(arguments);
            return FunctionCalculatorImpl.this.promote(this.handler.call(FunctionCalculatorImpl.this.getFunctions(arguments), arguments));
        }
    }

    @FunctionalInterface
    protected static interface Function
    extends Serializable {
        public Number call(List<Number> var1) throws ParseException;
    }
}

