/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat;

import java.math.RoundingMode;
import java.util.function.BiFunction;
import org.apfloat.Apcomplex;
import org.apfloat.ApcomplexMath;
import org.apfloat.Apfloat;
import org.apfloat.ApfloatArithmeticException;
import org.apfloat.ApfloatHelper;
import org.apfloat.ApfloatMath;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.Apint;
import org.apfloat.HypergeometricHelper;
import org.apfloat.RoundingHelper;
import org.apfloat.spi.Util;

class BesselHelper {
    private long targetPrecision;
    private long workingPrecision;
    private int radix;
    private Apcomplex \u03bd;
    private Apcomplex z;
    private Apint two;

    private BesselHelper(Apcomplex \u03bd, Apcomplex z) {
        this.radix = z.radix();
        this.targetPrecision = Math.min(\u03bd.precision(), z.precision());
        this.workingPrecision = ApfloatHelper.extendPrecision(this.targetPrecision, ApfloatHelper.getSmallExtraPrecision(this.radix));
        this.\u03bd = this.ensurePrecision(\u03bd);
        this.z = this.ensurePrecision(z);
        this.two = new Apint(2L, this.radix);
    }

    public static Apcomplex besselJ(Apcomplex \u03bd, Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        return new BesselHelper(\u03bd, z).besselJ();
    }

    public static Apcomplex besselI(Apcomplex \u03bd, Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        return new BesselHelper(\u03bd, z).besselI();
    }

    public static Apcomplex besselY(Apcomplex \u03bd, Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        return new BesselHelper(\u03bd, z).besselY();
    }

    public static Apcomplex besselK(Apcomplex \u03bd, Apcomplex z) throws ArithmeticException, ApfloatRuntimeException {
        return new BesselHelper(\u03bd, z).besselK();
    }

    private Apcomplex besselJ() throws ArithmeticException, ApfloatRuntimeException {
        Apcomplex result = this.besselJ(this.\u03bd);
        return ApfloatHelper.reducePrecision(result, ApfloatHelper.getSmallExtraPrecision(this.radix));
    }

    private Apcomplex besselI() throws ArithmeticException, ApfloatRuntimeException {
        Apcomplex result = this.besselI(this.\u03bd);
        return ApfloatHelper.reducePrecision(result, ApfloatHelper.getSmallExtraPrecision(this.radix));
    }

    private Apcomplex besselJ(Apcomplex \u03bd) throws ArithmeticException, ApfloatRuntimeException {
        return this.besselFirstKind(\u03bd, true);
    }

    private Apcomplex besselI(Apcomplex \u03bd) throws ArithmeticException, ApfloatRuntimeException {
        return this.besselFirstKind(\u03bd, false);
    }

    private Apcomplex besselFirstKind(Apcomplex \u03bd, boolean negate) throws ArithmeticException, ApfloatRuntimeException {
        if (\u03bd.isInteger() && this.z.isZero()) {
            return \u03bd.real().signum() == 0 ? Apint.ONES[this.radix] : this.z;
        }
        Apfloat one = Apint.ONES[this.radix].precision(ApfloatHelper.extendPrecision(this.workingPrecision, 1L));
        Apcomplex z2 = this.z.divide(this.two);
        Apcomplex z24 = z2.multiply(z2);
        return ApcomplexMath.pow(z2, \u03bd).multiply(ApcomplexMath.hypergeometric0F1Regularized(this.ensurePrecision(\u03bd.add(one)), negate ? z24.negate() : z24));
    }

    private Apcomplex besselY() throws ArithmeticException, ApfloatRuntimeException {
        if (this.z.isZero()) {
            throw new ApfloatArithmeticException("Bessel Y of zero", "besselY.ofZero", new Object[0]);
        }
        return this.besselSecondKind((\u03bd, z) -> {
            Apcomplex pi\u03bd = ApfloatMath.pi(this.workingPrecision, this.radix).multiply((Apcomplex)\u03bd);
            return this.besselJ((Apcomplex)\u03bd).multiply(ApcomplexMath.cos(pi\u03bd)).subtract(this.besselJ(\u03bd.negate())).divide(ApcomplexMath.sin(pi\u03bd));
        });
    }

    private Apcomplex besselK() throws ArithmeticException, ApfloatRuntimeException {
        Apcomplex z2;
        Apcomplex \u03bd21;
        if (this.z.isZero()) {
            throw new ApfloatArithmeticException("Bessel K of zero", "besselK.ofZero", new Object[0]);
        }
        Apint one = Apint.ONES[this.radix];
        Apfloat half = one.precision(this.workingPrecision).divide(this.two);
        Apcomplex \u03bd12 = this.ensurePrecision(this.\u03bd.add(half));
        Apcomplex u = HypergeometricHelper.hypergeometricU(\u03bd12, \u03bd21 = this.ensurePrecision(this.two.multiply(this.\u03bd).add(one)), z2 = this.two.multiply(this.z), true);
        if (u != null) {
            Apfloat pi = ApfloatMath.pi(this.workingPrecision, this.radix);
            Apcomplex result = ApfloatMath.sqrt(pi).multiply(ApcomplexMath.pow(z2, this.\u03bd)).multiply(ApcomplexMath.exp(this.z.negate())).multiply(u);
            return ApfloatHelper.limitPrecision(result, this.targetPrecision);
        }
        return this.besselSecondKind((\u03bd, z) -> {
            Apfloat pi = ApfloatMath.pi(this.workingPrecision, this.radix);
            return this.besselI(\u03bd.negate()).subtract(this.besselI((Apcomplex)\u03bd)).multiply(pi).divide(ApcomplexMath.sin(pi.multiply((Apcomplex)\u03bd)).multiply(this.two));
        });
    }

    private Apcomplex besselSecondKind(BiFunction<Apcomplex, Apcomplex, Apcomplex> f) throws ArithmeticException, ApfloatRuntimeException {
        Apcomplex result;
        long precisionLoss;
        if (this.\u03bd.isInteger()) {
            long digitLoss = this.workingPrecision;
            this.workingPrecision = Util.ifFinite(this.workingPrecision, this.workingPrecision + digitLoss);
            Apfloat offset = this.offset(-digitLoss);
            this.\u03bd = new Apcomplex(this.\u03bd.real().precision(Long.MAX_VALUE).add(offset), this.\u03bd.imag());
        } else {
            Apint \u03bdRounded = RoundingHelper.roundToInteger(this.\u03bd.real(), RoundingMode.HALF_EVEN).truncate();
            long digitLoss = Math.min(this.workingPrecision, -this.\u03bd.subtract(\u03bdRounded).scale());
            if (digitLoss > 0L) {
                this.workingPrecision = Util.ifFinite(this.workingPrecision, this.workingPrecision + digitLoss);
            }
        }
        do {
            this.\u03bd = this.ensurePrecision(this.\u03bd);
            this.z = this.ensurePrecision(this.z);
            result = f.apply(this.\u03bd, this.z);
            precisionLoss = result.isZero() ? this.workingPrecision : this.targetPrecision - result.precision();
            this.workingPrecision = Util.ifFinite(this.workingPrecision, this.workingPrecision + precisionLoss);
        } while (precisionLoss > 0L);
        return ApfloatHelper.limitPrecision(result, this.targetPrecision);
    }

    private Apfloat offset(long scale) {
        Apfloat offset = ApfloatMath.scale(new Apfloat("0.1", this.workingPrecision, this.radix), scale);
        return offset;
    }

    private Apcomplex ensurePrecision(Apcomplex z) {
        return ApfloatHelper.ensurePrecision(z, this.workingPrecision);
    }
}

