/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.function.BiFunction;
import org.apfloat.Apfloat;
import org.apfloat.ApfloatHelper;
import org.apfloat.ApfloatMath;
import org.apfloat.Apint;
import org.apfloat.ApintMath;
import org.apfloat.Aprational;
import org.apfloat.spi.Util;

class BernoulliHelper {
    private static final int BIG_THRESHOLD = 200000;

    BernoulliHelper() {
    }

    private static BiFunction<Apint, Apint, Apfloat> toApfloat(long precision) {
        return (numerator, denominator) -> numerator.precision(precision).divide((Apfloat)denominator);
    }

    public static Iterator<Apfloat> bernoullis(long n, long precision, int radix) {
        return n <= 200000L ? BernoulliHelper.bernoullisSmall(precision, radix) : BernoulliHelper.bernoullisBig(n, precision, radix);
    }

    public static Iterator<Apfloat> bernoullisSmall(long precision, int radix) {
        return new ApfloatBernoulliIterator(precision, radix);
    }

    public static Iterator<Apfloat> bernoullisBig(long n, long precision, int radix) {
        return BernoulliHelper.bernoullisBig(n, radix, BernoulliHelper.toApfloat(precision));
    }

    public static Iterator<Apfloat> bernoullis2(long n, long precision, int radix) {
        return n < 100000L ? BernoulliHelper.bernoullis2Small(precision, radix) : BernoulliHelper.bernoullis2Big(n, precision, radix);
    }

    public static Iterator<Apfloat> bernoullis2Small(long precision, int radix) {
        return new Bernoulli2Iterator<Apfloat>(BernoulliHelper.bernoullisSmall(precision, radix));
    }

    public static Iterator<Apfloat> bernoullis2Big(long n, long precision, int radix) {
        return BernoulliHelper.bernoullis2Big(n, radix, BernoulliHelper.toApfloat(precision));
    }

    public static Aprational bernoulli(long n, int radix) {
        return n <= 200000L ? BernoulliHelper.bernoulliSmall(n, radix) : BernoulliHelper.bernoulliBig(n, radix);
    }

    public static Aprational bernoulliSmall(long n, int radix) {
        assert (n > 0L);
        Aprational sum = Aprational.ZERO;
        for (long k = 1L; k <= n; ++k) {
            Apint binomial = Apint.ONES[radix];
            Apint part = Apint.ZERO;
            for (long v = 1L; v <= k; ++v) {
                binomial = binomial.multiply(new Apint(k + 1L - v, radix)).divide(new Apint(v, radix));
                Apint term = binomial.multiply(ApintMath.pow(new Apint(v, radix), n));
                part = (v & 1L) == 0L ? part.add(term) : part.subtract(term);
            }
            sum = sum.add(new Aprational(part, new Apint(k + 1L, radix)));
        }
        return sum;
    }

    public static Aprational bernoulliBig(long n, int radix) {
        assert (n > 1L);
        assert ((n & 1L) == 0L);
        Apint one = Apint.ONES[radix];
        Apint two = new Apint(2L, radix);
        long p = Math.max(1L, (long)Math.ceil((double)(n >>= 1) * Math.log(n) / Math.log(radix)));
        long precision = ApfloatHelper.extendPrecision(Util.multiplyExact(Util.multiplyExact(2L, n) + 1L, p));
        Apint f2n1 = ApintMath.factorial(2L * n - 1L, radix);
        Apfloat z = ApfloatMath.scale(new Apfloat(1L, precision, radix), -p);
        Apfloat v = ApfloatMath.scale(f2n1.multiply(ApfloatMath.tan(z)), -p);
        v = ApfloatMath.scale(v, 2L * p * (n - 1L));
        v = v.frac();
        v = ApfloatMath.scale(v, 2L * p);
        Apint t = v.truncate();
        Apint two2n1 = ApintMath.pow(two, 2L * n - 1L);
        Apint two2n = two2n1.multiply(two);
        Aprational b = new Aprational(new Apint((n & 1L) == 1L ? n : -n, radix).multiply(t), two2n.subtract(one).multiply(two2n1));
        return b;
    }

    public static Iterator<Aprational> bernoullis(long n, int radix) {
        return n <= 200000L ? BernoulliHelper.bernoullisSmall(radix) : BernoulliHelper.bernoullisBig(n, radix);
    }

    public static Iterator<Aprational> bernoullisSmall(int radix) {
        return new AprationalBernoulliIterator(radix);
    }

    public static Iterator<Aprational> bernoullisBig(long n, int radix) {
        return BernoulliHelper.bernoullisBig(n, radix, Aprational::new);
    }

    public static Iterator<Aprational> bernoullis2(long n, int radix) {
        return n < 100000L ? BernoulliHelper.bernoullis2Small(radix) : BernoulliHelper.bernoullis2Big(n, radix);
    }

    public static Iterator<Aprational> bernoullis2Small(int radix) {
        return new Bernoulli2Iterator<Aprational>(BernoulliHelper.bernoullisSmall(radix));
    }

    public static Iterator<Aprational> bernoullis2Big(long n, int radix) {
        return BernoulliHelper.bernoullis2Big(n, radix, Aprational::new);
    }

    public static <T extends Apfloat> Iterator<T> bernoullisBig(final long n, final int radix, final BiFunction<Apint, Apint, T> converter) {
        final Iterator<T> i = BernoulliHelper.bernoullis2Big(n >> 1, radix, converter);
        return new Iterator<T>(){
            private long k;

            @Override
            public boolean hasNext() {
                return this.k <= n;
            }

            @Override
            public T next() {
                if (this.k > n) {
                    throw new NoSuchElementException();
                }
                Apfloat b = this.k == 0L ? (Apfloat)converter.apply(Apint.ONES[radix], Apint.ONES[radix]) : (this.k == 1L ? (Apfloat)converter.apply(new Apint(-1L, radix), new Apint(2L, radix)) : ((this.k & 1L) == 1L ? (Apfloat)converter.apply(Apint.ZEROS[radix], Apint.ONES[radix]) : (Apfloat)i.next()));
                ++this.k;
                return b;
            }
        };
    }

    private static <T extends Apfloat> Iterator<T> bernoullis2Big(final long n, final int radix, final BiFunction<Apint, Apint, T> converter) {
        final Apint one = Apint.ONES[radix];
        final Apint two = new Apint(2L, radix);
        final long p = (long)Math.ceil((double)n * Math.log(n) / Math.log(radix));
        long precision = ApfloatHelper.extendPrecision(Util.multiplyExact(Util.multiplyExact(2L, n) + 1L, p));
        final Apint f2n1 = ApintMath.factorial(2L * n - 1L, radix);
        final Apfloat z = ApfloatMath.scale(new Apfloat(1L, precision, radix), -p);
        return new Iterator<T>(){
            private long k = 1L;
            private Apfloat v = ApfloatMath.scale(f2n1.multiply(ApfloatMath.tan(z)), -p);
            private Apint f2k1 = one;
            private Apint two2k1 = two;
            private Apint two2k;

            @Override
            public boolean hasNext() {
                return this.k <= n;
            }

            @Override
            public T next() {
                if (this.k > n) {
                    throw new NoSuchElementException();
                }
                long k = this.k;
                this.v = ApfloatMath.scale(this.v, 2L * p);
                Apint t1 = this.v.truncate();
                this.f2k1 = k == 1L ? this.f2k1 : this.f2k1.multiply(new Apint(2L * k - 1L, radix)).multiply(new Apint(2L * k - 2L, radix));
                Apint t = t1.multiply(this.f2k1).divide(f2n1);
                this.v = this.v.frac();
                this.two2k = this.two2k1.multiply(two);
                Apfloat b = (Apfloat)converter.apply(new Apint((k & 1L) == 1L ? k : -k, radix).multiply(t), this.two2k.subtract(one).multiply(this.two2k1));
                this.two2k1 = this.two2k.multiply(two);
                ++this.k;
                return b;
            }
        };
    }

    public static class ApfloatBernoulliIterator
    extends AbstractBernoulliIterator<Apfloat> {
        public ApfloatBernoulliIterator(long precision, int radix) {
            super(radix, BernoulliHelper.toApfloat(precision));
        }
    }

    public static class Bernoulli2Iterator<T extends Apfloat>
    implements Iterator<T> {
        private Iterator<T> iterator;

        public Bernoulli2Iterator(Iterator<T> iterator) {
            this.iterator = iterator;
            this.iterator.next();
        }

        @Override
        public boolean hasNext() {
            return true;
        }

        @Override
        public T next() {
            this.iterator.next();
            return (T)((Apfloat)this.iterator.next());
        }
    }

    public static class AprationalBernoulliIterator
    extends AbstractBernoulliIterator<Aprational> {
        public AprationalBernoulliIterator(int radix) {
            super(radix, Aprational::new);
        }
    }

    public static abstract class AbstractBernoulliIterator<T extends Apfloat>
    extends ConvertingIterator<T> {
        private int radix;
        private int n;
        private List<Apint> all;
        private Apint denominator;

        public AbstractBernoulliIterator(int radix, BiFunction<Apint, Apint, T> converter) {
            super(converter);
            this.radix = radix;
            this.all = new ArrayList<Apint>();
            this.denominator = Apint.ONES[radix];
        }

        @Override
        public boolean hasNext() {
            return true;
        }

        @Override
        public T next() {
            int i;
            Apint n1 = new Apint((long)(this.n + 1), this.radix);
            for (i = 0; i < this.n; ++i) {
                this.all.set(i, this.all.get(i).multiply(n1));
            }
            this.all.add(this.denominator);
            this.denominator = this.denominator.multiply(n1);
            for (i = this.n; i > 0; --i) {
                this.all.set(i - 1, this.all.get(i - 1).subtract(this.all.get(i)).multiply(new Apint((long)i, this.radix)));
            }
            Apint numerator = this.all.get(0);
            if (this.n == 1) {
                numerator = numerator.negate();
            }
            ++this.n;
            return (T)((Apfloat)this.converter.apply(numerator, this.denominator));
        }
    }

    public static abstract class ConvertingIterator<T extends Apfloat>
    implements Iterator<T> {
        protected BiFunction<Apint, Apint, T> converter;

        public ConvertingIterator(BiFunction<Apint, Apint, T> converter) {
            this.converter = converter;
        }
    }
}

