/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat;

import java.util.Iterator;
import org.apfloat.Apcomplex;
import org.apfloat.ApcomplexMath;
import org.apfloat.Apfloat;
import org.apfloat.ApfloatArithmeticException;
import org.apfloat.ApfloatHelper;
import org.apfloat.ApfloatMath;
import org.apfloat.Apint;
import org.apfloat.ApintMath;
import org.apfloat.Aprational;
import org.apfloat.AprationalMath;
import org.apfloat.BernoulliHelper;
import org.apfloat.InfiniteExpansionException;
import org.apfloat.spi.Util;

class HurwitzZetaHelper {
    HurwitzZetaHelper() {
    }

    public static Apcomplex zeta(Apcomplex s, Apcomplex a) {
        Apcomplex result;
        long precisionLoss;
        int radix = a.radix();
        Apint one = Apint.ONES[radix];
        if (s.equals(one)) {
            throw new ApfloatArithmeticException("Zeta of first argument one", "zeta.ofFirstOne", new Object[0]);
        }
        if (s.isZero() && a.isZero()) {
            Apint two = new Apint(2L, radix);
            return new Aprational(one, two);
        }
        Apcomplex sOrig = s;
        long targetPrecision = Math.min(s.precision(), a.precision());
        long precision = ApfloatHelper.extendPrecision(targetPrecision);
        s = ApfloatHelper.ensurePrecision(s, precision);
        a = ApfloatHelper.ensurePrecision(a, precision);
        if (ApcomplexMath.isNonPositiveInteger(s)) {
            long n1 = ApfloatHelper.longValueExact(one.subtract(s.real().truncate()));
            return HurwitzZetaHelper.bernoulliB(n1, a).divide(new Apfloat(n1, targetPrecision, radix)).negate();
        }
        if (ApcomplexMath.isNonPositiveInteger(a)) {
            if (s.real().signum() < 0 || s.isZero()) {
                Apcomplex t = Apcomplex.ZERO;
                Apcomplex sn = s.negate();
                long i = ApfloatHelper.longValueExact(a.real().truncate());
                while (i++ <= 0L) {
                    t = t.add(ApcomplexMath.pow(a, sn));
                    a = a.add(one);
                }
                t = ApfloatHelper.reducePrecision(t);
                s = sOrig;
                a = a.precision(targetPrecision);
                Apcomplex z = HurwitzZetaHelper.zeta(s, a);
                if (t.isZero()) {
                    return z;
                }
                return t.add(ApfloatHelper.ensurePrecision(z, precision));
            }
            throw new ApfloatArithmeticException("Zeta of second argument nonpositive integer", "zeta.ofSecondNonpositiveInteger", new Object[0]);
        }
        if (precision == Long.MAX_VALUE) {
            throw new InfiniteExpansionException("Cannot calculate zeta function to infinite precision", "zeta.infinitePrecision", new Object[0]);
        }
        long doublePrecision = ApfloatHelper.getDoublePrecision(radix);
        long zetaScale = Math.min(0L, HurwitzZetaHelper.zetaScale(s.precision(doublePrecision), a.precision(doublePrecision)));
        long targetScale = -Util.ifFinite(-zetaScale, targetPrecision - zetaScale);
        do {
            Apint N;
            Apint M = N = HurwitzZetaHelper.binarySearch(s, a, targetPrecision, targetScale);
            Apcomplex I = HurwitzZetaHelper.I(s, a, N);
            Apcomplex S = HurwitzZetaHelper.S(s, a, N.longValueExact());
            Apcomplex T = HurwitzZetaHelper.T(s, a, N, M.longValueExact());
            result = S.add(I).add(T);
            long l = precisionLoss = result.isZero() ? precision : targetPrecision - result.precision();
            if (precisionLoss <= 0L) continue;
            precision = Util.ifFinite(precision, precision + precisionLoss);
            targetScale = -Util.ifFinite(-targetScale, -targetScale + precisionLoss);
            s = ApfloatHelper.ensurePrecision(s, precision);
            a = ApfloatHelper.ensurePrecision(a, precision);
        } while (precisionLoss > 0L);
        return ApfloatHelper.limitPrecision(result, targetPrecision);
    }

    private static long zetaScale(Apcomplex s, Apcomplex a) {
        long extraPrecision = Math.max(0L, Math.max(s.scale(), a.scale()));
        Apint one = Apint.ONES[a.radix()];
        s = ApfloatHelper.extendPrecision(s, extraPrecision);
        a = ApfloatHelper.extendPrecision(a, extraPrecision);
        return ApcomplexMath.pow(a, one.subtract(s)).divide(s.subtract(one)).scale();
    }

    private static Apint binarySearch(Apcomplex s, Apcomplex a, long precision, long targetScale) {
        long M;
        int radix = a.radix();
        Apint one = Apint.ONES[radix];
        Apint two = new Apint(2L, radix);
        Apint min = ApintMath.max(two.subtract(a.real().truncate()), one.subtract(s.real()).divide(two).truncate().add(one));
        Apint N = ApintMath.max(new Apint(precision, radix), min);
        long low = M = ApfloatHelper.longValueExact(N);
        long high = M;
        Apfloat R = HurwitzZetaHelper.R(s, a, N, M);
        while (R.scale() >= targetScale) {
            low = M;
            M = Util.multiplyExact(2L, M);
            N = new Apint(M, radix);
            R = HurwitzZetaHelper.R(s, a, N, M);
            high = M;
        }
        if (low == high) {
            long lowLimit = Math.max(0L, min.longValueExact());
            while (R.scale() < targetScale && M > lowLimit) {
                high = M;
                M = Math.max(M >> 1, lowLimit);
                N = new Apint(M, radix);
                R = HurwitzZetaHelper.R(s, a, N, M);
                low = M;
            }
        }
        while (high - low > 1L) {
            M = high + low >>> 1;
            N = new Apint(M, radix);
            R = HurwitzZetaHelper.R(s, a, N, M);
            if (R.scale() >= targetScale) {
                low = M;
                continue;
            }
            high = M;
        }
        return new Apint(high, radix);
    }

    private static Apfloat R(Apcomplex s, Apcomplex a, Apint N, long M) {
        int radix = a.radix();
        Apint two = new Apint(2L, radix);
        Apint four = new Apint(4L, radix);
        Apint M2 = new Apint(2L * M, radix);
        Apfloat \u03c3 = s.real();
        Apfloat \u03c4 = s.imag();
        Apfloat \u03b1 = a.real();
        Apfloat \u03b2 = a.imag();
        Apfloat pi = ApfloatMath.pi(ApfloatHelper.getDoublePrecision(radix), radix);
        Apfloat K = ApfloatMath.exp(ApfloatMath.max(Apfloat.ZEROS[radix], HurwitzZetaHelper.expPrecision(\u03c4.multiply(ApfloatMath.atan(\u03b2.divide(\u03b1.add(N)))))));
        Apfloat R = K.multiply(HurwitzZetaHelper.J(N.add(\u03b1), \u03c3.add(M2)));
        return four.multiply(ApcomplexMath.abs(HurwitzZetaHelper.pochhammer(s, 2L * M))).divide(ApfloatMath.pow(two.multiply(pi), 2L * M)).multiply(ApfloatMath.abs(R));
    }

    private static Apfloat J(Apfloat A, Apfloat B) {
        Apint one = Apint.ONES[A.radix()];
        Apfloat B1 = B.subtract(one);
        return one.divide(B1.multiply(ApfloatMath.pow(A, B1)));
    }

    private static Apcomplex pochhammer(Apcomplex s, long n) {
        return ApcomplexMath.pochhammer(s, new Apfloat(n, s.precision(), s.radix()));
    }

    private static Apcomplex S(Apcomplex s, Apcomplex a, long N) {
        int radix = a.radix();
        Apcomplex sum = Apcomplex.ZEROS[radix];
        for (long k = 0L; k < N; ++k) {
            sum = sum.add(ApcomplexMath.pow(a.add(new Apint(k, radix)), s.negate()));
        }
        return sum;
    }

    private static Apcomplex I(Apcomplex s, Apcomplex a, Apint N) {
        int radix = a.radix();
        Apint one = Apint.ONES[radix];
        return ApcomplexMath.pow(a.add(N), one.subtract(s)).divide(s.subtract(one));
    }

    private static Apcomplex T(Apcomplex s, Apcomplex a, Apint N, long M) {
        long precision = Math.min(s.precision(), a.precision());
        int radix = a.radix();
        Apint one = Apint.ONES[radix];
        Apcomplex sum = new Aprational(one, new Apint(2L, radix));
        Apcomplex aN = a.add(N);
        Apcomplex aN2 = ApcomplexMath.pow(aN, -2L);
        Apcomplex pochhammer = s;
        Apcomplex factor = pochhammer.divide(aN);
        Iterator<Apfloat> bernoullis = BernoulliHelper.bernoullis2(M, precision, radix);
        for (long k = 1L; k <= M; ++k) {
            factor = factor.divide(new Apint(2L * k - 1L, radix).multiply(new Apint(2L * k, radix)));
            sum = sum.add(bernoullis.next().multiply(factor));
            if (k >= M) continue;
            pochhammer = pochhammer.add(one);
            factor = factor.multiply(pochhammer);
            pochhammer = pochhammer.add(one);
            factor = factor.multiply(pochhammer).multiply(aN2);
        }
        return sum.multiply(ApcomplexMath.pow(aN, s.negate()));
    }

    private static Apfloat expPrecision(Apfloat x) {
        return ApfloatHelper.extendPrecision(x, Math.max(0L, x.scale()));
    }

    private static Apcomplex bernoulliB(long n, Apcomplex z) {
        Apcomplex numerator;
        assert (n > 0L);
        long precision = z.precision();
        int radix = z.radix();
        if (z.isZero()) {
            return AprationalMath.bernoulli(n, radix);
        }
        Apcomplex sum = Apcomplex.ZEROS[radix];
        Apcomplex denominator = numerator = new Apfloat(1L, precision, radix);
        Iterator<Aprational> bernoullis = BernoulliHelper.bernoullis(n, radix);
        for (long k = 0L; k <= n; ++k) {
            Aprational b = bernoullis.next();
            sum = sum.add(b.multiply(numerator).divide(denominator));
            if (k >= n) continue;
            numerator = numerator.multiply(new Apint(n - k, radix));
            denominator = denominator.multiply(new Apint(k + 1L, radix)).multiply(z);
        }
        sum = sum.multiply(ApcomplexMath.pow(z, n));
        return ApfloatHelper.reducePrecision(sum);
    }
}

