/*
 * Decompiled with CFR 0.152.
 */
package org.apfloat;

import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Iterator;
import org.apfloat.Apfloat;
import org.apfloat.ApfloatArithmeticException;
import org.apfloat.ApfloatContext;
import org.apfloat.ApfloatHelper;
import org.apfloat.ApfloatRuntimeException;
import org.apfloat.Apint;
import org.apfloat.ApintMath;
import org.apfloat.Aprational;
import org.apfloat.BernoulliHelper;
import org.apfloat.ContinuedFractionHelper;
import org.apfloat.RoundingHelper;
import org.apfloat.spi.Util;

public class AprationalMath {
    private AprationalMath() {
    }

    public static Aprational pow(Aprational x, long n) throws ArithmeticException, ApfloatRuntimeException {
        if (n == 0L) {
            if (x.signum() == 0) {
                throw new ApfloatArithmeticException("Zero to power zero", "pow.zeroToZero", new Object[0]);
            }
            return Apint.ONES[x.radix()];
        }
        if (n < 0L) {
            x = Aprational.ONE.divide(x);
            n = -n;
        }
        int b2pow = 0;
        while ((n & 1L) == 0L) {
            ++b2pow;
            n >>>= 1;
        }
        Aprational r = x;
        while ((n >>>= 1) > 0L) {
            x = x.multiply(x);
            if ((n & 1L) == 0L) continue;
            r = r.multiply(x);
        }
        while (b2pow-- > 0) {
            r = r.multiply(r);
        }
        return r;
    }

    @Deprecated
    public static Aprational negate(Aprational x) throws ApfloatRuntimeException {
        return x.negate();
    }

    public static Aprational abs(Aprational x) throws ApfloatRuntimeException {
        if (x.signum() >= 0) {
            return x;
        }
        return x.negate();
    }

    public static Aprational copySign(Aprational x, Aprational y) throws ApfloatRuntimeException {
        if (y.signum() == 0) {
            return y;
        }
        if (x.signum() != y.signum()) {
            return x.negate();
        }
        return x;
    }

    public static Aprational scale(Aprational x, long scale) throws ApfloatRuntimeException {
        if (scale >= 0L) {
            return new Aprational(ApintMath.scale(x.numerator(), scale), x.denominator());
        }
        if (scale == Long.MIN_VALUE) {
            Apint scaler = ApintMath.pow(new Apint((long)x.radix(), x.radix()), 0x4000000000000000L);
            return new Aprational(x.numerator(), x.denominator().multiply(scaler)).divide(scaler);
        }
        return new Aprational(x.numerator(), ApintMath.scale(x.denominator(), -scale));
    }

    @Deprecated
    public static Apfloat round(Aprational x, long precision, RoundingMode roundingMode) throws IllegalArgumentException, ArithmeticException, ApfloatRuntimeException {
        return AprationalMath.roundToPrecision(x, precision, roundingMode);
    }

    public static Apfloat roundToPrecision(Aprational x, long precision, RoundingMode roundingMode) throws IllegalArgumentException, ArithmeticException, ApfloatRuntimeException {
        return RoundingHelper.roundToPrecision(x, precision, roundingMode);
    }

    public static Apint roundToInteger(Aprational x, RoundingMode roundingMode) throws IllegalArgumentException, ArithmeticException, ApfloatRuntimeException {
        return RoundingHelper.roundToInteger(x, roundingMode);
    }

    public static Apfloat roundToPlaces(Aprational x, long places, RoundingMode roundingMode) throws IllegalArgumentException, ArithmeticException, ApfloatRuntimeException {
        return RoundingHelper.roundToPlaces(x, places, roundingMode);
    }

    public static Aprational roundToMultiple(Aprational x, Aprational y, RoundingMode roundingMode) throws IllegalArgumentException, ArithmeticException, ApfloatRuntimeException {
        return RoundingHelper.roundToMultiple(x, y, roundingMode);
    }

    public static Aprational product(Aprational ... x) throws ApfloatRuntimeException {
        if (x.length == 0) {
            return Aprational.ONE;
        }
        Apint[] n = new Apint[x.length];
        Apint[] m = new Apint[x.length];
        for (int i = 0; i < x.length; ++i) {
            if (x[i].signum() == 0) {
                return Aprational.ZEROS[x[i].radix()];
            }
            n[i] = x[i].numerator();
            m[i] = x[i].denominator();
        }
        return new Aprational(ApintMath.product(n), ApintMath.product(m));
    }

    public static Aprational sum(Aprational ... x) throws ApfloatRuntimeException {
        if (x.length == 0) {
            return Aprational.ZERO;
        }
        x = (Aprational[])x.clone();
        Arrays.sort(x, Comparator.comparing(ApfloatHelper::size));
        return AprationalMath.recursiveSum(x, 0, x.length - 1);
    }

    public static Apint[] continuedFraction(Aprational x, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Maximum number of terms is not positive");
        }
        return (Apint[])Util.stream(ContinuedFractionHelper.continuedFraction(x)).limit(n).toArray(Apint[]::new);
    }

    public static Aprational[] convergents(Aprational x, int n) {
        if (n <= 0) {
            throw new IllegalArgumentException("Maximum number of convergents is not positive");
        }
        Iterator<Apint> continuedFraction = ContinuedFractionHelper.continuedFraction(x);
        return (Aprational[])Util.stream(ContinuedFractionHelper.convergents(continuedFraction, x.radix())).limit(n).toArray(Aprational[]::new);
    }

    public static Aprational max(Aprational x, Aprational y) throws ApfloatRuntimeException {
        return x.compareTo(y) > 0 ? x : y;
    }

    public static Aprational min(Aprational x, Aprational y) throws ApfloatRuntimeException {
        return x.compareTo(y) < 0 ? x : y;
    }

    public static Aprational doubleFactorial(long n) throws ArithmeticException, NumberFormatException, ApfloatRuntimeException {
        ApfloatContext ctx = ApfloatContext.getContext();
        int radix = ctx.getDefaultRadix();
        return AprationalMath.doubleFactorial(n, radix);
    }

    public static Aprational doubleFactorial(long n, int radix) throws ArithmeticException, NumberFormatException, ApfloatRuntimeException {
        if (n < 0L) {
            if ((n & 1L) == 0L) {
                throw new ApfloatArithmeticException("Double factorial of negative even number", "doubleFactorial.ofNegativeEven", new Object[0]);
            }
            return new Aprational(new Apint((n & 2L) == 0L ? n : -n, radix), ApintMath.doubleFactorial(-n, radix));
        }
        return ApintMath.doubleFactorial(n, radix);
    }

    public static Aprational binomial(Aprational n, Aprational k) throws ArithmeticException, ApfloatRuntimeException {
        if (n.isInteger() && k.isInteger()) {
            return ApintMath.binomial(n.numerator(), k.numerator());
        }
        if (n.isInteger() && n.signum() < 0 && !k.isInteger()) {
            throw new ApfloatArithmeticException("Binomial coefficient is not finite", "binomial.infinite", new Object[0]);
        }
        if (!k.isInteger()) {
            k = n.subtract(k);
        }
        if (!k.isInteger()) {
            throw new ApfloatArithmeticException("Binomial coefficient is not a rational number", "binomial.nonRational", new Object[0]);
        }
        int radix = n.radix();
        if (k.signum() < 0) {
            return Apint.ZEROS[radix];
        }
        Apint one = Apint.ONES[radix];
        Apint f = ApintMath.factorial(ApfloatHelper.longValueExact(k.truncate()), radix);
        return AprationalMath.pochhammer(n.subtract(k).add(one), k.numerator()).divide(f);
    }

    public static Aprational pochhammer(Aprational x, Apint n) {
        Apint one = Apint.ONES[x.radix()];
        if (n.signum() == 0) {
            return one;
        }
        if (n.equals(one)) {
            return x;
        }
        if (n.signum() < 0) {
            return one.divide(AprationalMath.pochhammer(x.add(n), n.negate()));
        }
        Apint two = new Apint(2L, x.radix());
        Apint k = n.divide(two);
        return AprationalMath.pochhammer(x, k).multiply(AprationalMath.pochhammer(x.add(k), n.subtract(k)));
    }

    public static Aprational bernoulli(long n) throws IllegalArgumentException, ApfloatRuntimeException {
        ApfloatContext ctx = ApfloatContext.getContext();
        int radix = ctx.getDefaultRadix();
        return AprationalMath.bernoulli(n, radix);
    }

    public static Aprational bernoulli(long n, int radix) throws IllegalArgumentException, NumberFormatException, ApfloatRuntimeException {
        if (n < 0L) {
            throw new IllegalArgumentException("Negative Bernoulli number: " + n);
        }
        if (n == 0L) {
            return Apint.ONES[radix];
        }
        if (n == 1L) {
            return new Aprational(new Apint(-1L, radix), new Apint(2L, radix));
        }
        if ((n & 1L) == 1L) {
            return Apint.ZEROS[radix];
        }
        return BernoulliHelper.bernoulli(n, radix);
    }

    public static Aprational harmonicNumber(Apint n) throws ArithmeticException, ApfloatRuntimeException {
        return AprationalMath.harmonicNumber(n, Apint.ONES[n.radix()]);
    }

    public static Aprational harmonicNumber(Apint n, Apint r) throws ArithmeticException, ApfloatRuntimeException {
        if (n.signum() == 0 || r.signum() == 0) {
            return n;
        }
        Apint one = Apint.ONES[n.radix()];
        if (n.signum() < 0) {
            if (r.signum() > 0) {
                throw new ApfloatArithmeticException("Negative harmonic number", "harmonicNumber.negative", new Object[0]);
            }
            return AprationalMath.harmonicNumber(n.negate().subtract(one), r).negate();
        }
        Apint[] h = AprationalMath.harmonicNumber(one, n, ApfloatHelper.longValueExact(r));
        return new Aprational(h[0], h[1]);
    }

    private static Apint[] harmonicNumber(Apint n, Apint m, long r) throws ArithmeticException, ApfloatRuntimeException {
        int radix = n.radix();
        Apint one = Apint.ONES[radix];
        if (n.equals(m)) {
            if (r >= 0L) {
                Apint[] h = new Apint[]{one, ApintMath.pow(n, r)};
                return h;
            }
            Apint[] h = new Apint[]{ApintMath.pow(n, -r), one};
            return h;
        }
        Apint k = n.add(m).divide(new Apint(2L, radix));
        Apint[] hl = AprationalMath.harmonicNumber(n, k, r);
        Apint[] hh = AprationalMath.harmonicNumber(k.add(one), m, r);
        Apint[] h = new Apint[]{hl[0].multiply(hh[1]).add(hl[1].multiply(hh[0])), hl[1].multiply(hh[1])};
        return h;
    }

    private static Aprational recursiveSum(Aprational[] x, int n, int m) throws ApfloatRuntimeException {
        if (n == m) {
            return x[n];
        }
        int k = n + m >>> 1;
        return AprationalMath.recursiveSum(x, n, k).add(AprationalMath.recursiveSum(x, k + 1, m));
    }
}

